%*************Step 1:  This piece of code goes in the FirstGuiOpeningFnc **************

% Locate the FirstGuiOpeningFnc.  Copy and Paste the code below (lines 8-18) right after 
% The first five lines of comments but before the first executable line in the opening function: 
handles.output = hObject;


%The Opening Function Sets up how FirstGui looks it is first opened


axes(handles.axes1);                % Point to the top plot tagged as axes1
% Plot a 1 Hz sine wave with amplitude of 5
t = 0:1e-6:1; y = 5*sin(2*pi*t);
plot(t,y); axis([0 1 -10 10]);

axes(handles.axes2);                % Point to the bottom plot tagged as axes2
% Plot a 1 Hz cosine wave with amplitude of 1
t = -1:0.001:1; y = cos(2*pi*t); plot(t,y); title('cos(2*pi*t)');


% **********Step 2:  This piece of code goes under GraphMenu_Callback****************
% Locate the GraphMenu_Callback Function.  Copy lines 25-42 and paste into
% this callback function.

% This will read the selection from the popup menu and plot the indicated function
axes(handles.axes2);    % Makes axes2 the selected plot window
cla;                    % Clears axes2

menu_choice = get(handles.GraphMenu, 'Value');  % Get user choice from pop-up menu tagged as menu1
switch menu_choice
    case 1
        t = -1:0.001:1; y = cos(2*pi*t); plot(t,y); title('cos(2*pi*t)');
    case 2
        t = -2*pi:0.001:2*pi; y = tan(t); 
        plot(t,y); axis([-2*pi 2*pi -10 10]); title('tan(t)');
    case 3
        t = 0:0.001:5; y = exp(-t); plot(t,y); title('exp(-t)');
    case 4
        t = -5:0.001:3; y = exp(t); plot(t,y); title('exp(t)');
    case 5
        t = 0.1:0.001:5; y = log(t); plot(t,y); title('ln(t)');
end


% ****Step 3:  This piece of code goes under FreqBox_Callback*******
% Locate the FreqBox_Callback Function.  Copy lines 49-68 and paste in
% FreqBox_Callback function.

%This function will retrieve the value a user enters in for frequency.  If
%the frequency entered is not a number, it will be set the value to one and user
%will be prompted to enter a number.

freq = str2double(get(handles.FreqBox,'String'));   % Get the frequency from box tagged FreqBox
if isnan(freq)                               % If freq isn't a number over-write it with a 1
    freq = 1;
    set(handles.FreqBox, 'String',1);        % Write a 1 into the box
    errordlg('Input must be a number');      % Tell user to put in a number
    pause(2);
end

amp = get(handles.AmpSlider,'Value');    % Get amplitude from Slider tagged AmpSlider

axes(handles.axes1);    %Select axes1 for plotting
cla;                    %Clear out axes 1

t = 0:1e-6:1;
y = amp*sin(2*pi*freq*t);
plot(t,y); axis([0 1 -10 10]);


%*********Step 4:  This piece of code goes under AmpSlider_Callback********
% Locate the AmpSlider_Callback Function.  Copy lines 75-86 and paste into
% AmpSlider_Callback Function.

amp = get(handles.AmpSlider, 'Value');    % Get the new slider value

freq = str2double(get(handles.FreqBox,'String'));  % Get frequency from box tagged FreqBox

axes(handles.axes1);    %Select axes1 for plotting
cla;                    %Clear out axes 1

t = 0:1e-6:1;
y = amp*sin(2*pi*freq*t);
plot(t,y); axis([0 1 -10 10]);

set(handles.AmpBox, 'String',amp);  % Writes value of slider into box tagged AmpBox


%******** Step5:  This piece of code goes under AmpBox_Callback***********
% Locate the AmpBox_Callback Function.  Copy lines 93-110 and paste into
% the AmpBox Callback Function.

amp = str2double(get(handles.AmpBox,'String'));  % Retrieve what was entered in box
if isnan(amp) || amp < 0 || amp > 10
    amp = get(handles.AmpSlider,'Value');   % Get Current Slider Value
    set(handles.AmpBox,'String',amp);       % Write the slider value into AmpBox
    errordlg('Input Must be a Number from 0 to 10')
    pause(2)    
end
   
set(handles.AmpSlider,'Value',amp)          % Move Slider to reflect value

freq = str2double(get(handles.FreqBox,'String'));  % Get frequency from box tagged FreqBox

axes(handles.axes1);    %Select axes1 for plotting
cla;                    %Clear out axes 1

t = 0:1e-6:1;
y = amp*sin(2*pi*freq*t);
plot(t,y); axis([0 1 -10 10]);



