/* File "mxInternals_R2018B.h"                      */
/* Hacked internal MXARRAY DEFINITION               */
/* Matlab version: R2018b                           */

#ifndef MXINTERNALS_H

#define MXINTERNALS_H

#include "mex.h"

#define NumericalMask       0x00000080
#define ComplexMask         0x00000800
#define SparseMask          0x00000010

typedef struct mxArray_tag mxArray_tag;

struct mxArray_tag {

    mxArray_tag     *B_Xlink;     
    mxClassID       classID;            
    unsigned int    unknown1;           
    mxArray_tag     *F_Xlink;    
    mwSize          ndims;              
    unsigned int    refcount;                   /* Number of mxArray* objects that point to this structure */
    unsigned int    Mask;                       /* See some of the mask values defined above */     
    union { 
        mwSize          rows;                   /* Valid if the array has <= 2 dimensions */
        mwSize          *pSize;                 /* vector of size, in heap, Valid if the array has > 2 dimensions */
    } size;
    mwSize          cols;                       /* If the array has > 2 dimensions, this is actually numel(X) / size(X,1) */
    union { 
        struct {
            void            *Data;              
            unsigned int    unknown0;         
            unsigned int    unknown1;           
            unsigned int    unknown2;           
            unsigned int    unknown3;           
            unsigned int    unknown4;           
            unsigned int    unknown5;           
        } number_array;
        struct {
            void          * Data;                     
            mwIndex       * pRowIndex;          
            mwIndex       * pColFirstElement;           /* pColFirstElement[j] is the index of the first entry in column j (see mxSetJc).  The number of non-sparse elements is pColFirstElement[cols] */
            mwSize          nzmax;                      /* The number of non zero elements allocated for the sparse array */
        } sparse_array;
        struct {
            mxArray_tag  ** Data;              
            unsigned int    unknown1;           
            unsigned int    unknown2;           
            unsigned int    unknown3;           
            unsigned int    unknown4;           
            unsigned int    unknown5;           
            unsigned int    unknown6;           
            unsigned int    unknown7;           
        } cell_array;
        struct {
            mxArray_tag  ** Data;              
            void          * pFieldNames;                /* N.B. I have no idea how field names are stored */
            unsigned int    unknown1;           
            unsigned int    unknown2;           
            unsigned int    unknown3;           
            unsigned int    unknown4;           
            unsigned int    unknown5;           
        } struct_array;
    } data;
    unsigned int    unknown3;           
    unsigned int    unknown4;           
    unsigned int    unknown5;           
    unsigned int    unknown6;           
    unsigned int    unknown7;           
};

#endif
